IF EXISTS (select * from sysobjects where name like '%T_Insert_UsuarioZona%')
DROP TRIGGER T_Insert_UsuarioZona
go

CREATE TRIGGER T_Insert_UsuarioZona
ON  UsuarioZona
FOR INSERT, UPDATE
AS
	---------- WebManager ----------
	DECLARE @IdZona DECIMAL(20,0);
	DECLARE @IdPersona DECIMAL(20,0);
	DECLARE @Orden DECIMAL(10,0);
	DECLARE @RutaCompleta NVARCHAR(500);
	
	DECLARE Elems_Cursor55555 CURSOR FOR
	SELECT IdZona,IdPersona,Orden,RutaCompleta FROM INSERTED;
	OPEN Elems_Cursor55555
	
	FETCH NEXT FROM Elems_Cursor55555 INTO @IdZona,@IdPersona,@Orden,@RutaCompleta
	WHILE @@FETCH_STATUS = 0
	BEGIN	
	
		PRINT 'Migrar datos a tabla WM_UsuarioWebZona WebManager'

		--En caso de que la zona tenga servidores vinculados, actualizamos a 1 el valor de TieneServidores, si no a 0
		IF (SELECT COUNT(*) FROM WM_UsuarioWebZona WHERE IdZona=@IdZona AND IdUsuarioWeb=@IdPersona) > 0
		BEGIN
			UPDATE WM_UsuarioWebZona SET Orden=@Orden,RutaCompleta=@RutaCompleta WHERE WM_UsuarioWebZona.IdZona=@IdZona AND WM_UsuarioWebZona.IdUsuarioWeb=@IdPersona
		END
		ELSE
		BEGIN
			INSERT INTO WM_UsuarioWebZona (IdZona,IdUsuarioWeb,Orden,RutaCompleta) VALUES (@IdZona,@IdPersona,@Orden,@RutaCompleta)
		END

		PRINT 'Fin migrar datos a tabla WM_UsuarioWebZona WebManager'

	FETCH NEXT FROM Elems_Cursor55555 INTO @IdZona,@IdPersona,@Orden,@RutaCompleta
	END
	
	CLOSE Elems_Cursor55555
	DEALLOCATE Elems_Cursor55555

	---------- Fin WebManager ----------

GO
ALTER TABLE UsuarioZona ENABLE TRIGGER T_Insert_UsuarioZona
GO